

<?php $__env->startSection('content'); ?>

    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-12">

                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white text-center">
                        <h4 class="mb-0">College List</h4>
                    </div>

                    <div class="card-body table-responsive">
                        <table class="table table-bordered table-hover align-middle">
                            <thead class="table-dark text-center">
                                <tr>
                                    <th>#</th>
                                    <th>College Name</th>
                                    <th>Address</th>
                                    <th>Rating</th>
                                    <th>Contact</th>
                                    <th>Facilities</th>
                                    <th>Courses</th>
                                    <th>Images</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $colleges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $college): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>

                                        <td>
                                            <strong><?php echo e($college->name); ?></strong><br>
                                            <small class="text-muted"><?php echo e($college->about); ?></small>
                                        </td>

                                        <td>
                                            <?php echo e($college->location); ?>

                                            
                                        </td>

                                        <td class="text-center">
                                            <?php echo e($college->rating ?? 'N/A'); ?>

                                        </td>

                                        <td>
                                            <?php echo e($college->phone ?? 'N/A'); ?><br>
                                            <?php echo e($college->email ?? 'N/A'); ?><br>
                                            <?php if($college->website): ?>
                                                <a href="<?php echo e($college->website); ?>" target="_blank">Visit</a>
                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?>
                                        </td>

                                        <td>
                                            <ul class="mb-0">
                                                <?php $__currentLoopData = $college->facilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $facility): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($facility->name); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </td>

                                        <td>
                                            <ul class="mb-0">
                                                <?php $__currentLoopData = $college->courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($course->name); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </td>

                                        <td class="text-center">
                                            <?php $__empty_2 = true; $__currentLoopData = $college->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                <img src="<?php echo e(asset('storage/' . $image->image_url)); ?>" class="img-thumbnail mb-1"
                                                    width="60">
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                <span class="text-muted">No Image</span>
                                            <?php endif; ?>
                                        </td>


                                        <td class="text-center">
                                            <button class="btn btn-sm btn-warning editBtn" data-bs-toggle="modal"
                                                data-bs-target="#editCollegeModal" data-id="<?php echo e($college->id); ?>"
                                                data-name="<?php echo e($college->name); ?>" data-location="<?php echo e($college->location); ?>"
                                                data-rating="<?php echo e($college->rating); ?>" data-phone="<?php echo e($college->phone); ?>"
                                                data-email="<?php echo e($college->email); ?>" data-website="<?php echo e($college->website); ?>"
                                                data-about="<?php echo e($college->about); ?>">
                                                Edit
                                            </button>

                                            <form action="<?php echo e(route('admin.college.destroy', $college->id)); ?>" method="POST"
                                                class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                    Delete
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="9" class="text-center text-muted">
                                            No colleges found.
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>

            </div>
        </div>
    </div>
<div class="modal fade" id="editCollegeModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form method="POST" id="editCollegeForm">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="modal-content">
                <div class="modal-header bg-warning">
                    <h5 class="modal-title">Edit College</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input type="hidden" id="college_id">

                    <div class="mb-3">
                        <label>College Name</label>
                        <input type="text" name="name" id="edit_name" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label>Location</label>
                        <input type="text" name="location" id="edit_location" class="form-control">
                    </div>

                    <div class="mb-3">
                        <label>Rating</label>
                        <input type="number" step="0.1" max="5" name="rating" id="edit_rating" class="form-control">
                    </div>

                    <div class="mb-3">
                        <label>Phone</label>
                        <input type="text" name="phone" id="edit_phone" class="form-control">
                    </div>

                    <div class="mb-3">
                        <label>Email</label>
                        <input type="email" name="email" id="edit_email" class="form-control">
                    </div>

                    <div class="mb-3">
                        <label>Website</label>
                        <input type="url" name="website" id="edit_website" class="form-control">
                    </div>

                    <div class="mb-3">
                        <label>About</label>
                        <textarea name="about" id="edit_about" class="form-control" rows="3"></textarea>
                    </div>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button class="btn btn-success">Update</button>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll('.editBtn').forEach(button => {
        button.addEventListener('click', function () {
            const id = this.dataset.id;

            document.getElementById('edit_name').value = this.dataset.name;
            document.getElementById('edit_location').value = this.dataset.location;
            document.getElementById('edit_rating').value = this.dataset.rating;
            document.getElementById('edit_phone').value = this.dataset.phone;
            document.getElementById('edit_email').value = this.dataset.email;
            document.getElementById('edit_website').value = this.dataset.website;
            document.getElementById('edit_about').value = this.dataset.about;

            document.getElementById('editCollegeForm').action =
                "<?php echo e(route('admin.college.update', ':id')); ?>".replace(':id', id);
        });
    });
});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Astra\CareerApps\CareerApp\resources\views/admin/manage_college.blade.php ENDPATH**/ ?>